﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Testing.GraphicsAdapterOverview.Common;
using Testing.GraphicsAdapterOverview.Graphics;

namespace Testing.GraphicsAdapterOverview
{
    /// <summary>
    /// Interaktionslogik für MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="MainWindow"/> class.
        /// </summary>
        public MainWindow()
        {
            InitializeComponent();

            this.Loaded += OnLoaded;
        }

        /// <summary>
        /// Default load method. Loads all devices.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="RoutedEventArgs"/> instance containing the event data.</param>
        private async void OnLoaded(object sender, RoutedEventArgs e)
        {
            if (this.IsInDesignTimeWpf()) { return; }

            // Load all device instances
            List<EngineDevice> devices = new List<EngineDevice>();
            await Task.Factory.StartNew(() =>
            {
                devices.AddRange(EngineDevice.CreateDevices(false));
            });

            // Apply device list on UI
            this.MainTreeView.ItemsSource = devices;
        }

        /// <summary>
        /// Called when user wants to close.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The <see cref="RoutedEventArgs"/> instance containing the event data.</param>
        private void OnCmdExitClick(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
