﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

//Some namespace mappings
using WIC = SharpDX.WIC;

//Some type mappings
using WicFactory = SharpDX.WIC.ImagingFactory;

namespace Testing.GraphicsAdapterOverview.Graphics
{
    public class DeviceHandlerWIC
    {
        private WicFactory m_imagingFactory;

        /// <summary>
        /// Initializes a new instance of the <see cref="DeviceHandlerWIC" /> class.
        /// </summary>
        internal DeviceHandlerWIC()
        {
            m_imagingFactory = new WicFactory();
        }

        /// <summary>
        /// Gets the WIC factory object.
        /// </summary>
        internal WicFactory Factory
        {
            get { return m_imagingFactory; }
        }

        public bool IsInitialized
        {
            get { return m_imagingFactory != null; }
        }
    }
}
