﻿// Some namespace mappings
using DXGI = SharpDX.DXGI;
using D3D11 = SharpDX.Direct3D11;

namespace Testing.GraphicsAdapterOverview.Graphics
{
    public class DeviceHandlerDXGI
    {
        private DXGI.Factory1 m_factory;
        private DXGI.Adapter1 m_adapter;
        private DXGI.Device1 m_device;

        /// <summary>
        /// Initializes a new instance of the <see cref="DeviceHandlerDXGI"/> class.
        /// </summary>
        internal DeviceHandlerDXGI(DXGI.Adapter1 adapter, D3D11.Device device)
        {
            m_device = device.QueryInterface<DXGI.Device1>();
            m_adapter = adapter;
            m_factory = m_adapter.GetParent<DXGI.Factory1>();
        }

        /// <summary>
        /// Unloads all resources.
        /// </summary>
        internal void UnloadResources()
        {
            m_factory = GraphicsHelper.DisposeObject(m_factory);
            m_adapter = GraphicsHelper.DisposeObject(m_adapter);
            m_device = GraphicsHelper.DisposeObject(m_device);
        }

        /// <summary>
        /// Gets current factory object.
        /// </summary>
        /// <value>The factory.</value>
        internal DXGI.Factory1 Factory
        {
            get { return m_factory; }
        }

        /// <summary>
        /// Gets the DXGI device.
        /// </summary>
        internal DXGI.Device1 Device
        {
            get { return m_device; }
        }

        /// <summary>
        /// Gets current adapter used for drawing.
        /// </summary>
        internal DXGI.Adapter1 Adapter
        {
            get { return m_adapter; }
        }

        public bool IsInitialized
        {
            get
            {
                return (m_factory != null) &&
                       (m_device != null) &&
                       (m_adapter != null);
            }
        }
    }
}
