﻿
//Some namespace mappings
using DWrite = SharpDX.DirectWrite;

namespace Testing.GraphicsAdapterOverview.Graphics
{
    public class DeviceHandlerDWrite
    {
        //Resources for DirectWrite
        private DWrite.Factory m_factory;

        /// <summary>
        /// Initializes a new instance of the <see cref="DeviceHandlerDWrite"/> class.
        /// </summary>
        /// <param name="core">The core.</param>
        /// <param name="dxgiHandler">The dxgi handler.</param>
        internal DeviceHandlerDWrite()
        {
            //Create DirectWrite Factory object
            m_factory = new DWrite.Factory(DWrite.FactoryType.Shared);
        }

        /// <summary>
        /// Unloads all resources.
        /// </summary>
        internal void UnloadResources()
        {
            m_factory = GraphicsHelper.DisposeObject(m_factory);
        }

        /// <summary>
        /// Gets the Factory object.
        /// </summary>
        internal DWrite.Factory Factory
        {
            get { return m_factory; }
        }

        /// <summary>
        /// Is DirectWrite initialized successfully?
        /// </summary>
        public bool IsInitialized
        {
            get { return m_factory != null; }
        }
    }
}
