﻿
//Some namespace mappings
using D2D = SharpDX.Direct2D1;

//Some type mappings
using D2dFactory = SharpDX.Direct2D1.Factory;

namespace Testing.GraphicsAdapterOverview.Graphics
{
    public class DeviceHandlerD2D
    {
        //Resources form Direct2D api
        private D2dFactory m_factory;

        /// <summary>
        /// Initializes a new instance of the <see cref="DeviceHandlerD2D"/> class.
        /// </summary>
        /// <param name="debugEnabled">Is debugging enabled?</param>
        internal DeviceHandlerD2D(bool debugEnabled)
        {
            //Create the factory object
            m_factory = new D2dFactory(
                D2D.FactoryType.SingleThreaded,
                debugEnabled ? D2D.DebugLevel.Information : D2D.DebugLevel.None);
        }

        /// <summary>
        /// Unloads all resources.
        /// </summary>
        internal void UnloadResources()
        {
            m_factory = GraphicsHelper.DisposeObject(m_factory);
        }

        /// <summary>
        /// Gets the factory object.
        /// </summary>
        internal D2D.Factory Factory
        {
            get { return m_factory; }
        }

        /// <summary>
        /// Is Direct2D initialized?
        /// </summary>
        public bool IsInitialized
        {
            get { return m_factory != null; }
        }
    }
}
