﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// Some namespace mappings
using DXGI = SharpDX.DXGI;

namespace Testing.GraphicsAdapterOverview.Graphics
{
    internal static class GraphicsHelper
    {
        public static readonly DXGI.Format DEFAULT_TEXTURE_FORMAT = DXGI.Format.R8G8B8A8_UNorm;

        /// <summary>
        /// Disposes the given object.
        /// </summary>
        public static T DisposeObject<T>(T objectToDispose)
            where T : class, IDisposable
        {
            if (objectToDispose == null) { return null; }

            try { objectToDispose.Dispose(); }
            catch{ }

            return null;
        }
    }
}
