﻿using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

// Some namespace mappings
using D3D11 = SharpDX.Direct3D11;
using D3D10 = SharpDX.Direct3D10;
using D3D9 = SharpDX.Direct3D9;
using DXGI = SharpDX.DXGI;

namespace Testing.GraphicsAdapterOverview.Graphics
{
    public class EngineOutputInfo
    {
        private const string TRANSLATABLE_GROUP_COMMON_OUTPUT_INFO = "Output";

        private int m_outputIndex;
        private DXGI.OutputDescription m_outputDescription;

        /// <summary>
        /// Initializes a new instance of the <see cref="OutputItemViewModel" /> class.
        /// </summary>
        /// <param name="output">The output to get all data from.</param>
        internal EngineOutputInfo(int outputIndex, DXGI.Output output)
        {
            m_outputIndex = outputIndex;
            m_outputDescription = output.Description;
        }

        /// <summary>
        /// Gets the name of the output device.
        /// </summary>
        [Category(TRANSLATABLE_GROUP_COMMON_OUTPUT_INFO)]
        public string DeviceName
        {
            get { return m_outputDescription.DeviceName; }
        }

        [Category(TRANSLATABLE_GROUP_COMMON_OUTPUT_INFO)]
        public bool IsAttachedToDesktop
        {
            get { return m_outputDescription.IsAttachedToDesktop; }
        }

        [Category(TRANSLATABLE_GROUP_COMMON_OUTPUT_INFO)]
        public string DesktopResolution
        {
            get { return m_outputDescription.DesktopBounds.Width + "x" + m_outputDescription.DesktopBounds.Height.ToString(); }
        }

        [Category(TRANSLATABLE_GROUP_COMMON_OUTPUT_INFO)]
        public string DesktopLocation
        {
            get { return "X = " + m_outputDescription.DesktopBounds.X + ", Y = " + m_outputDescription.DesktopBounds.Y; }
        }

        [Category(TRANSLATABLE_GROUP_COMMON_OUTPUT_INFO)]
        public string Rotation
        {
            get { return m_outputDescription.Rotation.ToString(); }
        }
    }
}
