﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Threading;

namespace Testing.GraphicsAdapterOverview.Common
{
    static class _Extensions
    {
        /// <summary>
        /// If a method wants to execute an async action in a "fire-and-foreget" manner this
        /// method should be attached by these reasons:
        ///  - Mark this behavior for later source code readers
        ///  - Throw exeptions correctly (e. g. to the calling UI thread)
        ///  
        /// See some explanation here:
        ///  http://stackoverflow.com/questions/12144077/async-await-when-to-return-a-task-vs-void
        /// </summary>
        /// <param name="task">The task to "forget".</param>
        public static async void FireAndForeget(this Task task)
        {
            await task;
        }

        /// <summary>
        /// Check for any object within the application whether we are in design time.
        /// </summary>
        /// <param name="anyObject">Any object.. This object does not have any influence to the method.</param>
        public static bool IsInDesignTimeWpf(this object anyObject)
        {
            // Simple mathod. Taken from http://www.codeproject.com/Tips/61858/Detect-Design-Time-Mode-in-WPF
            return System.ComponentModel.DesignerProperties.GetIsInDesignMode(
                new DependencyObject());
        }
    }
}
